<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Lesson extends Model 
{

    protected $table = 'lessons';
    public $timestamps = true;
    protected $fillable = array('teacher_id', 'price', 'name', 'type', 'description');

    public function times()
    {
        return $this->belongsToMany('App\Models\Lesson', 'lessons_times');
    }

    public function teacher()
    {
        return $this->belongsTo('App\Models\Teacher');
    }

    public function files()
    {
        return $this->morphMany('App\Models\File', 'fileable');
    }

}